var gNewTypeRV    = null;
var gUpdateTypeRV = null;
var gList   = null;
var gDS     = null;
var gPrefApplicationsBundle = null;
var gExtensionField = null;
var gMIMEDescField  = null;
var gHandlerField   = null;
var gNewTypeButton  = null;
var gEditButton     = null;
var gRemoveButton   = null;
function newType()
{
  var handlerOverride = new HandlerOverride();
  window.openDialog("chrome://mtypes/content/pref/pref-applications-edit.xul", "appEdit", "chrome,modal=yes,resizable=no", handlerOverride);
  if (gNewTypeRV) {
    //gList.builder.rebuild();
    gList.setAttribute("ref", "urn:mimetypes");
    gNewTypeRV = null;
  }
}
function removeType()
{
  var uri = gList.selectedItems[0].id;
  var handlerOverride = new HandlerOverride(uri);
  if ( !handlerOverride.useSystemDefault && !handlerOverride.saveToDisk ) {
    var titleMsg = gPrefApplicationsBundle.getString("removeHandlerTitle");
    var dialogMsg = gPrefApplicationsBundle.getString("removeHandler");
    dialogMsg = dialogMsg.replace(/%n/g, "\n");
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
    var remove = promptService.confirm(window, titleMsg, dialogMsg);
    if (!remove) {
      return;
    }
  }
  removeOverride(handlerOverride.mimeType);
  gList.setAttribute("ref", "urn:mimetypes");
  selectApplication();
}
function editType()
{
  if (gList.selectedItems && gList.selectedItems[0]) {
    var uri = gList.selectedItems[0].id;
    var handlerOverride = new HandlerOverride(uri);
    window.openDialog("chrome://mtypes/content/pref/pref-applications-edit.xul", "appEdit", "chrome,modal=yes,resizable=no", handlerOverride);
    selectApplication();
  }
}
const xmlSinkObserver = {
  onBeginLoad: function(aSink)
  {
  },
  onInterrupt: function(aSink)
  {
  },
  onResume: function(aSink)
  {
  },
  onEndLoad: function(aSink)
  {
    aSink.removeXMLSinkObserver(this);
    try {
      var prefService = Components.classes["@mozilla.org/preferences;1"].getService(Components.interfaces.nsIPrefService);
      var prefBranch = prefService.getBranch("browser.helperApps.neverAsk.");
      if (!prefBranch) return;
    } catch(e) { return; }
    var neverAskSave = new Array();
    var neverAskOpen = new Array();
    try {
      neverAskSave = prefBranch.getCharPref("saveToDisk").split(",");
    } catch(e) {}
    try {
      neverAskOpen = prefBranch.getCharPref("openFile").split(",");
    } catch(e) {}    
    var i;
		var type;
    var newEntries = {};
    for ( i = 0; i < neverAskSave.length; i++ ) {
      type = unescape(neverAskSave[i]);
      if (type != "" && !mimeHandlerExists(type)) {
        newEntries[type] = "saveToDisk";
      }
    }
    for ( i = 0; i < neverAskOpen.length; i++ ) {
      type = unescape(neverAskOpen[i]);
      if (type != "" && !mimeHandlerExists(type)) {
        newEntries[type] = "useSystemDefault";
      }
    }
    for ( var newEntry in newEntries ) {
      this.createNewEntry(newEntry, newEntries[newEntry]);
    }
    try { prefBranch.clearUserPref("saveToDisk"); } catch(e) {}
    try { prefBranch.clearUserPref("openFile"); } catch(e) {}
  },
  onError: function(aSink, aStatus, aMsg)
  {
  },
  createNewEntry: function(mimeType, action)
  {
    var entry = new HandlerOverride(MIME_URI(mimeType));
    entry.mUpdateMode = false;
    entry.mimeType    = mimeType;
    entry.description = "";
    entry.isEditable  = true;
    entry.alwaysAsk   = false;
    entry.appPath     = "";
    entry.appDisplayName = "";
    entry[action]     = true;
    entry.buildLinks();
  }
}
function Startup()
{
  gPrefApplicationsBundle = document.getElementById("bundle_prefApplications");
  gList = document.getElementById("appList"); 
  gExtensionField = document.getElementById("extension");        
  gMIMEDescField  = document.getElementById("mimeDesc");
  gHandlerField   = document.getElementById("handler");
  gNewTypeButton  = document.getElementById("newTypeButton");
  gEditButton     = document.getElementById("editButton");
  gRemoveButton   = document.getElementById("removeButton");
  updateLockedButtonState(false);
  const mimeTypes = "UMimTyp";
  var fileLocator = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);  
  var file = fileLocator.get(mimeTypes, Components.interfaces.nsIFile);
  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  var fileHandler = ioService.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
  gDS = gRDF.GetDataSource(fileHandler.getURLSpecFromFile(file));
  gList.database.AddDataSource(gDS);
  gList.setAttribute("ref", "urn:mimetypes");
  if (gDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).loaded) {
    xmlSinkObserver.onEndLoad(gDS.QueryInterface(Components.interfaces.nsIRDFXMLSink));
  } else {
    gDS.QueryInterface(Components.interfaces.nsIRDFXMLSink).addXMLSinkObserver( xmlSinkObserver );
  }
}
function selectApplication()
{
  if (gList.selectedItems && gList.selectedItems.length && gList.selectedItems[0]) {
    var uri = gList.selectedItems[0].id;
    var handlerOverride = new HandlerOverride(uri);
    gExtensionField.setAttribute("value", handlerOverride.extensions);
    gMIMEDescField.setAttribute("value", handlerOverride.description);
    if (handlerOverride.handleInternal == "true")
      gHandlerField.setAttribute("value",
                                 gPrefApplicationsBundle.getString("handleInternally"));
    else if (handlerOverride.saveToDisk == "true")
      gHandlerField.setAttribute("value",
                                 gPrefApplicationsBundle.getString("saveToDisk"));
    else if (handlerOverride.useSystemDefault == "true")
      gHandlerField.setAttribute("value",
                                 gPrefApplicationsBundle.getString("useSystemDefault"));
    else 
      gHandlerField.setAttribute("value",
                                 gPrefApplicationsBundle.getFormattedString("useHelperApp", [handlerOverride.appDisplayName]));
    var ext;
    var posOfFirstSpace = handlerOverride.extensions.indexOf(" ");
    if (posOfFirstSpace > -1)
      ext = handlerOverride.extensions.substr(0, posOfFirstSpace);
    else
      ext = handlerOverride.extensions;
    var imageString = "moz-icon://" + "dummy." + ext.toLowerCase() + "?size=32&contentType=" + handlerOverride.mimeType;
    document.getElementById("contentTypeImage").setAttribute("src", imageString);
    updateLockedButtonState(handlerOverride.isEditable == "true");
    delete handlerOverride;
  } else {
    updateLockedButtonState(false)
    gHandlerField.removeAttribute("value");
    document.getElementById("contentTypeImage").removeAttribute("src");
    gExtensionField.removeAttribute("value");
    gMIMEDescField.removeAttribute("value");
  }
}
function updateLockedButtonState(handlerEditable)
{
  gNewTypeButton.disabled = parent.hPrefWindow.getPrefIsLocked(gNewTypeButton.getAttribute("prefstring") );
  if (!handlerEditable ||
      parent.hPrefWindow.getPrefIsLocked(gEditButton.getAttribute("prefstring"))) {
    gEditButton.disabled = true;
  } else {
    gEditButton.disabled = false;
  }
  if (!handlerEditable ||
      parent.hPrefWindow.getPrefIsLocked(gRemoveButton.getAttribute("prefstring"))) {
    gRemoveButton.disabled = true;
  } else {
    gRemoveButton.disabled = false;
  }
}